#include <stdio.h>

#include "UnityNP.h"
#include "toolkit.h"
#include "MessagePipe.h"
#include <np.h>

namespace UnityPlugin
{
	DO_EXPORT( int, PrxInitialize ) (unsigned int creationFlags)
	{
		return InitializeToolkit(creationFlags, -1);
	}

	DO_EXPORT( int, PrxInitializeWithNpAgeRating ) (unsigned int creationFlags, int npAgeRating)
	{
		return InitializeToolkit(creationFlags, npAgeRating);
	}
	
	std::string gSessionImageFilePath;

	DO_EXPORT( void, PrxSetSessionImage ) (const char* imageFilePath)
	{
		gSessionImageFilePath.assign(imageFilePath);
	}

	DO_EXPORT( void, PrxUpdate ) ()
	{
		Update();
	}

	DO_EXPORT( void, PrxShutDown ) ()
	{
		ShutDownToolkit();
	}

	DO_EXPORT( UInt64, PrxGetNetworkTime ) ()
	{
		CellRtcTick tick;
		if(sceNpManagerGetNetworkTime(&tick) < 0)
		{
			return 0;
		}
		return (UInt64)tick.tick * 10;
	}
}
